// PageSettingAlarmEffect.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageSettingAlarmEffect.h"
#include "LogManager.h"

// CPageSettingAlarmEffect dialog

IMPLEMENT_DYNAMIC(CPageSettingAlarmEffect, CDialog)

CPageSettingAlarmEffect::CPageSettingAlarmEffect(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CPageSettingAlarmEffect::IDD, pParent)
	, m_bEnableLight(FALSE)
	, m_bEnableText(FALSE)
	, m_bEnableRegion(FALSE)
	, m_iDurationLight(0)
	, m_iDurationRegion(0)
	, m_iDurationOsd(0)
	, m_iFlashtime(0)
	, m_iRegionWidth(0)
	, m_iRegionX(0)
	, m_iRegionY(0)
	, m_csText(_T(""))
	, m_iLeftTop_X(0)
	, m_iLeftTop_Y(0)
	, m_iTextWidth(0)
	, m_iTextHeight(0)
	, m_iLeft(0)
	, m_iTop(0)
	, m_iRight(0)
	, m_iBottom(0)
{
	m_iLogonID = -1;
	m_iChannelNo = -1;
}

CPageSettingAlarmEffect::~CPageSettingAlarmEffect()
{
}

void CPageSettingAlarmEffect::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK_LIGHT, m_bEnableLight);
	DDX_Check(pDX, IDC_CHECK_OSD, m_bEnableText);
	DDX_Check(pDX, IDC_CHECK_REGION, m_bEnableRegion);
	DDX_Control(pDX, IDC_COMBO_ALIGN, m_cmbAlign);
	DDX_Control(pDX, IDC_BTN_LIGHT_SHOW_COLOR, m_btnLightShowColor);
	DDX_Control(pDX, IDC_BTN_REGION_SHOW_COLOR, m_btnRegionShowColor);
	DDX_Control(pDX, IDC_BTN_OSD_SHOW_COLOR, m_btnOsdShowColor);
	DDX_Control(pDX, IDC_COMBO_CHANNEL, m_cmbChannel);
	DDX_Text(pDX, IDC_EDIT_LIGHT_TIME, m_iDurationLight);
	DDX_Text(pDX, IDC_EDIT_REGION_TIME, m_iDurationRegion);
	DDX_Text(pDX, IDC_EDIT_OSD_TIME, m_iDurationOsd);
	DDX_Text(pDX, IDC_EDIT_FLASHTIME, m_iFlashtime);
	DDX_Text(pDX, IDC_EDIT_BOARDWIDTH, m_iRegionWidth);
	DDX_Text(pDX, IDC_EDIT_REGION_X, m_iRegionX);
	DDX_Text(pDX, IDC_EDIT_REGION_Y, m_iRegionY);
	DDX_Text(pDX, IDC_EDIT_OSD_TEXT, m_csText);
	DDX_Text(pDX, IDC_EDIT_LEFTTOP_X, m_iLeftTop_X);
	DDX_Text(pDX, IDC_EDIT_LEFT_TOP_Y, m_iLeftTop_Y);
	DDX_Text(pDX, IDC_EDIT_OSD_W, m_iTextWidth);
	DDX_Text(pDX, IDC_EDIT_OSD_H, m_iTextHeight);
	DDX_Text(pDX, IDC_EDIT_LEFT_SPACE, m_iLeft);
	DDX_Text(pDX, IDC_EDIT_TOP_SPACE, m_iTop);
	DDX_Text(pDX, IDC_EDIT_RIGHT_SPACE, m_iRight);
	DDX_Text(pDX, IDC_EDIT_BOTTOM_SPACE, m_iBottom);
	DDX_Control(pDX, IDC_LIST_POINTS, m_lcPoints);
	DDV_MaxChars(pDX, m_csText, 64);
	DDX_Control(pDX, IDC_COMBO_PICNUM, m_cmbWindowNum);
	DDX_Control(pDX, IDC_COMBO_EFFECT_TEXT_FONTSIZE, m_cboEffectTextFontSize);
}


BEGIN_MESSAGE_MAP(CPageSettingAlarmEffect, CDialog)
	ON_BN_CLICKED(IDC_BTN_LIGHT_COLOR, &CPageSettingAlarmEffect::OnBnClickedBtnLightColor)
	ON_BN_CLICKED(IDC_BTN_REGION_COLOR, &CPageSettingAlarmEffect::OnBnClickedBtnRegionColor)
	ON_BN_CLICKED(IDC_BTN_OSD_COLOR, &CPageSettingAlarmEffect::OnBnClickedBtnOsdColor)
	ON_CBN_SELCHANGE(IDC_COMBO_CHANNEL, &CPageSettingAlarmEffect::OnCbnSelchangeComboChannel)
	ON_BN_CLICKED(IDC_BUTTON_SET_LIGHT, &CPageSettingAlarmEffect::OnBnClickedButtonSetLight)
	ON_BN_CLICKED(IDC_BUTTON_SET_REGION, &CPageSettingAlarmEffect::OnBnClickedButtonSetRegion)
	ON_BN_CLICKED(IDC_BUTTON_SET_TEXT, &CPageSettingAlarmEffect::OnBnClickedButtonSetText)
	ON_BN_CLICKED(IDC_BUTTON_ADD_POINT, &CPageSettingAlarmEffect::OnBnClickedButtonAddPoint)
	ON_BN_CLICKED(IDC_BUTTON_DELETE_POINT, &CPageSettingAlarmEffect::OnBnClickedButtonDeletePoint)
	ON_CBN_SELCHANGE(IDC_COMBO_PICNUM, &CPageSettingAlarmEffect::OnCbnSelchangeComboPicnum)
END_MESSAGE_MAP()

BOOL CPageSettingAlarmEffect::OnInitDialog()
{
	CLS_CBasePage::OnInitDialog();

	//0:ûԶ,1:Ͻ,2:½,3:Ͻ,4½,5.
	m_cmbAlign.AddString("ûԶ");
	m_cmbAlign.AddString("Ͻ");
	m_cmbAlign.AddString("½");
	m_cmbAlign.AddString("Ͻ");
	m_cmbAlign.AddString("½");
	m_cmbAlign.AddString("");

	m_cboEffectTextFontSize.AddString("1");
	m_cboEffectTextFontSize.AddString("2");
	m_cboEffectTextFontSize.AddString("3");
	m_cboEffectTextFontSize.AddString("4");
	m_cboEffectTextFontSize.AddString("5");
	m_cboEffectTextFontSize.SetCurSel(0);

	int iRet = CreateChannelCombo(m_iLogonID,&m_cmbChannel);
	if (iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CPageSettingAlarmEffect::OnInitDialog] CreateChannelCombo failed!Ret(%d),Error(0x%08x),ID(%d)", iRet, GetLastError(), m_iLogonID);
	}

	m_lcPoints.SetExtendedStyle(LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);
	m_lcPoints.InsertColumn(0,"Points",LVCFMT_LEFT, 100);

	m_btnLightShowColor.SetChildNum(0);
	m_btnLightShowColor.SetColor(0,RGB(0,0,0));
	m_btnRegionShowColor.SetChildNum(0);
	m_btnRegionShowColor.SetColor(0,RGB(0,0,0));
	m_btnOsdShowColor.SetChildNum(0);
	m_btnOsdShowColor.SetColor(0,RGB(0,0,0));

	for (int i = 0; i < DEC_MAX_WINDOW_TOTAL_NUM; i++)
	{
		CString str;
		str.Format("%d",i);
		m_cmbWindowNum.AddString(str);
	}
	m_cmbWindowNum.SetCurSel(0);
	


	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

// CPageSettingAlarmEffect message handlers
void CPageSettingAlarmEffect::Initialize(TDECPARAM* _pdecParam)
{
	if(_pdecParam != NULL)
	{
		UI_UpdateDialog();

	}
}
void CPageSettingAlarmEffect::UI_UpdateDialog()
{
	UpdateAlarmEffect();
}
void CPageSettingAlarmEffect::UpdateAlarmEffect()
{
	if(m_iLogonID < 0)
	{
		return;
	}
	int iChannelNo = GetComboData(&m_cmbChannel);
	int iWindowsNo = m_cmbWindowNum.GetCurSel();

	//update light
	DecAlarmEffectLight tDecAlarmEffectLight = {0};
	int iRet = -1;
	iRet = DEC_ClientGetDevConfig(m_iLogonID, iChannelNo, iWindowsNo, 
		CMD_DEC_CFG_ALARM_EFFECT_LIGHT, &tDecAlarmEffectLight, sizeof(DecAlarmEffectLight));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::Initialize][DEC_ClientGetDevConfig:CMD_DEC_CFG_ALARM_EFFECT_LIGHT] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_iLogonID);
	}

	m_bEnableLight = tDecAlarmEffectLight.iEnable;
	m_iDurationLight = tDecAlarmEffectLight.iDuration;
	m_iLightColor = tDecAlarmEffectLight.iColor;
	SetButtonShowColor(m_btnLightShowColor,m_iLightColor);
	m_iFlashtime = tDecAlarmEffectLight.iFlashtime;
	
	//update region
	DecAlarmEffectRegion tDecAlarmEffectRegion = {0};
	iRet = DEC_ClientGetDevConfig(m_iLogonID, iChannelNo, iWindowsNo, 
		CMD_DEC_CFG_ALARM_EFFECT_REGION, &tDecAlarmEffectRegion, sizeof(DecAlarmEffectRegion));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::Initialize][DEC_ClientGetDevConfig:CMD_DEC_CFG_ALARM_EFFECT_REGION] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_iLogonID);
	}

	m_bEnableRegion = tDecAlarmEffectRegion.iEnable;
	m_iDurationRegion = tDecAlarmEffectRegion.iDuration;
	m_iRegionWidth = tDecAlarmEffectRegion.iWidth;
	m_iRegionColor = tDecAlarmEffectRegion.iColor;
	SetButtonShowColor(m_btnRegionShowColor,m_iRegionColor);
	m_vRegionPts.clear();
	for (int i = 0; i < tDecAlarmEffectRegion.iPointCount; i++)
	{
		m_vRegionPts.push_back(tDecAlarmEffectRegion.tPoints[i]);
	}
	UpdateList();

	//update effect text

	DecAlarmEffectText tDecAlarmEffectText = {0};
	iRet = DEC_ClientGetDevConfig(m_iLogonID, iChannelNo, iWindowsNo, 
		CMD_DEC_CFG_ALARM_EFFECT_TEXT, &tDecAlarmEffectText, sizeof(DecAlarmEffectText));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::Initialize][DEC_ClientGetDevConfig:CMD_DEC_CFG_ALARM_EFFECT_TEXT] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_iLogonID);
	}

	m_bEnableText = tDecAlarmEffectText.iEnable;
	m_iDurationOsd = tDecAlarmEffectText.iDuration;
	if (tDecAlarmEffectText.iFontSize > 0) {
		m_cboEffectTextFontSize.SetCurSel(tDecAlarmEffectText.iFontSize - 1);
	} else {
		m_cboEffectTextFontSize.SetCurSel(0);
	}
	m_iOsdColor = tDecAlarmEffectText.iColor;
	SetButtonShowColor(m_btnOsdShowColor,m_iOsdColor);
	m_csText = tDecAlarmEffectText.cText;
	m_cmbAlign.SetCurSel(tDecAlarmEffectText.iTextAlign);
	m_iLeftTop_X = tDecAlarmEffectText.tPoint.x;
	m_iLeftTop_Y = tDecAlarmEffectText.tPoint.y;
	m_iTextWidth = tDecAlarmEffectText.iTextWidth;
	m_iTextHeight = tDecAlarmEffectText.iTextHeight;
	m_iLeft = tDecAlarmEffectText.iLeft;
	m_iTop = tDecAlarmEffectText.iTop;
	m_iRight = tDecAlarmEffectText.iRight;
	m_iBottom = tDecAlarmEffectText.iBottom;

	UpdateData(FALSE);
}

void CPageSettingAlarmEffect::UpdateList()
{
	m_lcPoints.DeleteAllItems();
	for (size_t i = 0; i < m_vRegionPts.size(); i++)
	{
		CString csPoint;
		csPoint.Format("%d:(%d,%d)",i,m_vRegionPts[i].x,m_vRegionPts[i].y);
		m_lcPoints.InsertItem(i,csPoint);
	}
}
void CPageSettingAlarmEffect::OnBnClickedBtnLightColor()
{
	// TODO: Add your control notification handler code here
	if (m_iLogonID < 0)
	{
		AddLog(LOG_TYPE_MSG,"","Invalid logon id(%d)",m_iLogonID);
		return;
	}

	CColorDialog clsColorDlg;
	int iRet = clsColorDlg.DoModal();
	if (IDOK == iRet)
	{
		m_iLightColor = clsColorDlg.GetColor();
		SetButtonShowColor(m_btnLightShowColor,m_iLightColor);
	}
}
void CPageSettingAlarmEffect::SetButtonShowColor(CLS_SplitterButton &showColorButton,int iColor)
{
	try
	{
		showColorButton.RemoveChild(0);
		showColorButton.AddChild(0);
		showColorButton.SetColor(0,RGB(GetRValue(iColor), GetGValue(iColor),GetBValue(iColor)));
	}
	catch (CException* e)
	{
		e->ReportError();
		e->Delete();
	}
}
void CPageSettingAlarmEffect::OnBnClickedBtnRegionColor()
{
	if (m_iLogonID < 0)
	{
		AddLog(LOG_TYPE_MSG,"","Invalid logon id(%d)",m_iLogonID);
		return;
	}

	CColorDialog clsColorDlg;
	int iRet = clsColorDlg.DoModal();
	if (IDOK == iRet)
	{
		m_iRegionColor = clsColorDlg.GetColor();
		SetButtonShowColor(m_btnRegionShowColor,m_iRegionColor);
	}
}

void CPageSettingAlarmEffect::OnBnClickedBtnOsdColor()
{
	CColorDialog clsColorDlg;
	int iRet = clsColorDlg.DoModal();
	if (IDOK == iRet)
	{
		m_iOsdColor = clsColorDlg.GetColor();
		SetButtonShowColor(m_btnOsdShowColor,m_iOsdColor);
	}
}


void CPageSettingAlarmEffect::OnCbnSelchangeComboChannel()
{
	// TODO: Add your control notification handler code here
	UpdateAlarmEffect();
}

void CPageSettingAlarmEffect::OnBnClickedButtonSetLight()
{
	if (m_iLogonID < 0)
	{
		AddLog(LOG_TYPE_MSG,"","Invalid logon id(%d)",m_iLogonID);
		return;
	}

	UpdateData(TRUE);

	int iChannelNo = GetComboData(&m_cmbChannel);
	int iWindowsNo = m_cmbWindowNum.GetCurSel();
	DecAlarmEffectLight tDecAlarmEffectLight = {0};

    tDecAlarmEffectLight.iSize = sizeof(DecAlarmEffectLight);
	tDecAlarmEffectLight.iEnable = m_bEnableLight;
	tDecAlarmEffectLight.iDuration = m_iDurationLight;
	tDecAlarmEffectLight.iColor = m_iLightColor;
	tDecAlarmEffectLight.iFlashtime = m_iFlashtime;

	int iRet = -1;
	iRet = DEC_ClientSetDevConfig(m_iLogonID, iChannelNo, iWindowsNo, 
		CMD_DEC_CFG_ALARM_EFFECT_LIGHT, &tDecAlarmEffectLight, sizeof(DecAlarmEffectLight));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::Initialize][DEC_ClientSetDevConfig:CMD_DEC_CFG_ALARM_EFFECT_LIGHT] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_iLogonID);
	}
}

void CPageSettingAlarmEffect::OnBnClickedButtonSetRegion()
{
	if (m_iLogonID < 0)
	{
		AddLog(LOG_TYPE_MSG,"","Invalid logon id(%d)",m_iLogonID);
		return;
	}
	UpdateData(TRUE);
	int iChannelNo = GetComboData(&m_cmbChannel);
	int iWindowsNo = m_cmbWindowNum.GetCurSel();
	DecAlarmEffectRegion tDecAlarmEffectRegion = {0};
	

	tDecAlarmEffectRegion.iEnable = m_bEnableRegion;
	tDecAlarmEffectRegion.iDuration = m_iDurationRegion;
	tDecAlarmEffectRegion.iWidth = m_iRegionWidth;
	tDecAlarmEffectRegion.iColor = m_iRegionColor;

	int iPointSize = m_vRegionPts.size();
	if(iPointSize > MAX_EFFECTREGION_POINT_COUNT)
	{
		iPointSize = MAX_EFFECTREGION_POINT_COUNT;
	}
	tDecAlarmEffectRegion.iPointCount = iPointSize;
	for (int i = 0; i < tDecAlarmEffectRegion.iPointCount; i++)
	{
		tDecAlarmEffectRegion.tPoints[i] = m_vRegionPts[i];
	}

	int iRet = DEC_ClientSetDevConfig(m_iLogonID, iChannelNo, iWindowsNo, 
		CMD_DEC_CFG_ALARM_EFFECT_REGION, &tDecAlarmEffectRegion, sizeof(DecAlarmEffectRegion));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::Initialize][DEC_ClientSetDevConfig:CMD_DEC_CFG_ALARM_EFFECT_REGION] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_iLogonID);
	}
}

void CPageSettingAlarmEffect::OnBnClickedButtonSetText()
{
	if (m_iLogonID < 0)
	{
		AddLog(LOG_TYPE_MSG,"","Invalid logon id(%d)",m_iLogonID);
		return;
	}
	UpdateData(TRUE);
	int iChannelNo = GetComboData(&m_cmbChannel);
	int iWindowsNo = m_cmbWindowNum.GetCurSel();
	DecAlarmEffectText tDecAlarmEffectText = {0};

	tDecAlarmEffectText.iEnable = m_bEnableText;
	tDecAlarmEffectText.iDuration = m_iDurationOsd;
	tDecAlarmEffectText.iFontSize = m_cboEffectTextFontSize.GetCurSel() + 1;
	tDecAlarmEffectText.iColor = m_iOsdColor;
	strncpy(tDecAlarmEffectText.cText,m_csText.GetBuffer(0),m_csText.GetLength());
	tDecAlarmEffectText.iTextAlign = m_cmbAlign.GetCurSel();
	tDecAlarmEffectText.tPoint.x = m_iLeftTop_X;
	tDecAlarmEffectText.tPoint.y = m_iLeftTop_Y;
	tDecAlarmEffectText.iTextWidth = m_iTextWidth;
	tDecAlarmEffectText.iTextHeight = m_iTextHeight;
	tDecAlarmEffectText.iLeft = m_iLeft;
	tDecAlarmEffectText.iTop = m_iTop;
	tDecAlarmEffectText.iRight = m_iRight;
	tDecAlarmEffectText.iBottom = m_iBottom;

	
	int iRet = DEC_ClientSetDevConfig(m_iLogonID, iChannelNo,iWindowsNo, 
		CMD_DEC_CFG_ALARM_EFFECT_TEXT, &tDecAlarmEffectText, sizeof(DecAlarmEffectText));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::Initialize][DEC_ClientSetDevConfig:CMD_DEC_CFG_ALARM_EFFECT_TEXT] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_iLogonID);
	}

}

void CPageSettingAlarmEffect::OnBnClickedButtonAddPoint()
{
	if(m_vRegionPts.size()>=MAX_EFFECTREGION_POINT_COUNT)
	{
		AfxMessageBox("");
		return;
	}

	UpdateData(TRUE);
	POINT pt;
	pt.x = m_iRegionX;
	pt.y = m_iRegionY;
	m_vRegionPts.push_back(pt);

	UpdateList();
}

void CPageSettingAlarmEffect::OnBnClickedButtonDeletePoint()
{
	int iCount = m_lcPoints.GetItemCount();
	for (int iPos = iCount-1; iPos >= 0; iPos--)
	{
		int iState = m_lcPoints.GetItemState(iPos, LVIS_SELECTED);
		if(iState != 0)
		{
			std::vector<POINT>::iterator pos = m_vRegionPts.begin();
			m_vRegionPts.erase(pos+iPos);
		}
	}
	UpdateList();
}

void CPageSettingAlarmEffect::OnCbnSelchangeComboPicnum()
{
	UpdateAlarmEffect();
}
